//
//  GSOutlineImporter.h
//  GlyphsCore
//
//  Created by Georg Seifert on 06.09.21.
//  Copyright © 2021 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class GSLayer;

@protocol GSOutlineImporter <NSObject>

@property NSAffineTransform *transformation;

- (BOOL)readData:(nonnull NSData *)data toLayer:(nonnull GSLayer *)layer bounds:(nullable NSRect *)outBounds error:(out NSError **)error;

- (BOOL)readFile:(nonnull NSURL *)URL toLayer:(nonnull GSLayer *)layer bounds:(out nullable NSRect *)outBounds error:(out NSError **)error;

@end

NS_ASSUME_NONNULL_END
